#include "GlobalExtern.h"

void StartGame() {
	//////////dprintf("StartGame Start\n");
	FILE* f;
	f = fopen("Z:\\game.txt" , "r");
	if(!f) {
		CommandLineLaunch = 0;
		XGetCustomLaunchData();
		if(g_autoLaunchGame == 1) {
			CommandLineLaunch = 1;
			string e = g_launchData.szFilename;
			//////////dprintf("Command Line Game Start: %s\n", e.c_str());
//			LoadScreenIni();
			LoadGameIni(e);
			Emulation = true;
			setDisplay = true;
			//////////dprintf("SegaMain\n");
			GUIState = 1;
			Init_2xSaIMMX(565);
			SegaMain(e);
		}
		//////////dprintf("Not starting game\n");
		return;
	}

	string e = GetFileString(f);
	//////////dprintf("Game Start: %s\n", e.c_str());
	fclose(f);
	DeleteFile("Z:\\game.txt");
//	LoadScreenIni();
	LoadGameIni(e);
	Emulation = true;
	setDisplay = true;
	//////////dprintf("SegaMain\n");
	if(e[1] == '_')
		resetGame = 10;
	SegaMain(e);
}

void OptionScreen() {
	char fileName[260];
	if(!TexOption) {
		sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\option.png");
		D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
			D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
			D3DX_DEFAULT,0,NULL,NULL,&TexOption);
	}
}

//Code for handling 128Meg machines added by Madmab
#define IA32_MTRR_DEF_TYPE      0x02FF

//-------------------------------------------------------------------
// READMSRREG
//! \brief    Write to a 64 bit MSR register
//-------------------------------------------------------------------
inline void READMSRREG( UINT32 reg, LARGE_INTEGER *val ) 
{
  UINT32 lowPart, highPart;
  __asm {
    mov   ecx, reg
    rdmsr
    mov   lowPart, eax
    mov   highPart, edx
  };

  val->LowPart = lowPart;
  val->HighPart = highPart;
}

//-------------------------------------------------------------------
// WRITEMSRREG64
//! \brief    Write to a 64 bit MSR register
//-------------------------------------------------------------------
inline void WRITEMSRREG( UINT32 reg, LARGE_INTEGER val ) 
{
  __asm {
    mov   ecx, reg
    mov   eax, val.LowPart
    mov   edx, val.HighPart
    wrmsr
  };
}

void xbox_enable_128Meg()
{
  LARGE_INTEGER regVal;
  MEMORYSTATUS stat;

  GlobalMemoryStatus( &stat );

  if ( stat.dwTotalPhys >= 68000000 )
  {
	  /* Extra RAM detected, activate */

      // Grab the existing default type
	  READMSRREG( IA32_MTRR_DEF_TYPE, &regVal );

	  // Set the default to WriteBack (0x06)
      regVal.LowPart = (regVal.LowPart & ~0xFF) | 0x06;
      WRITEMSRREG( IA32_MTRR_DEF_TYPE, regVal );
  }
}

void Init() {
	Unmount("C:");
	Unmount("E:");
	Unmount("F:");
	Unmount("G:");
	Unmount("R:");
	Unmount("X:");
	Unmount("Y:");
	Unmount("Z:");
	Mount("C:", "Harddisk0\\Partition2");
	Mount("E:", "Harddisk0\\Partition1");
	Mount("F:", "Harddisk0\\Partition6");
	Mount("G:", "Harddisk0\\Partition7");
	Mount("X:", "Harddisk0\\Partition3");
	Mount("Y:", "Harddisk0\\Partition4");
	Mount("Z:", "Harddisk0\\Partition5");
	Mount("R:","Cdrom0");	
	SetupPath();

	char fileName[260];
	for(int d = 0; d < 8; d++) {
		if(d == 0) 
			sprintf(fileName,"%s%s", RomPath1.c_str(), "\\");
		if(d == 1) 
			sprintf(fileName,"%s%s", RomPath2.c_str(), "\\");
		if(d == 2) 
			sprintf(fileName,"%s%s", RomPath3.c_str(), "\\");
		if(d == 3) 
			sprintf(fileName,"%s%s", RomPath4.c_str(), "\\");
		if(d == 4) 
			sprintf(fileName,"%s%s", RomPath5.c_str(), "\\");
		if(d == 5) 
			sprintf(fileName,"%s%s", RomPath6.c_str(), "\\");
		if(d == 6) 
			sprintf(fileName,"%s%s", RomPath7.c_str(), "\\");
		if(d == 7) 
			sprintf(fileName,"%s%s", RomPath8.c_str(), "\\");
		for(int i = 0; i < 260; i++)
			szAppRomPaths[d][i] = fileName[i];
	}
	
	xbox_enable_128Meg();
	BurnLibInit();
	LoadIni();
	LoadScreenIni();
	DirectInit();
	Device->CreateVertexBuffer(sizeof(VertexListMenu),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferMenu);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferMainMenuOverlay1);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferMainMenuOverlay2);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferMainMenuOverlay3);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferMainMenuOverlay4);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferMainMenuOverlay5);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferMainMenuOverlay6);
	FontInit(1);
	SetFontHeight(FontSize);
	InputInit(); 
	DirectSoundInit();
	effectInit();
	OptionGUIControllerItems.push_back("Configure Buttons");
	OptionGUIControllerItems.push_back("Turbo Options");
	OptionGUIControllerItems.push_back("Macro Options");
	OptionGUIControllerItems.push_back("Cursor Speed: 7");
	GameOptionItems.push_back("Return to Game");
	GameOptionItems.push_back("Reset Game");
	GameOptionItems.push_back("Save State");
	GameOptionItems.push_back("Load State");
	GameOptionItems.push_back("Take Screenshot");
	GameOptionItems.push_back("Video Options");
	GameOptionItems.push_back("Sound Options");
	GameOptionItems.push_back("General Options");
	GameOptionItems.push_back("Controller Options");
	GameOptionItems.push_back("Load Game Guide");
	GameOptionItems.push_back("Cheat Codes");
	GameOptionItems.push_back("Arcade Information");
	GameOptionItems.push_back("Arcade Settings");
	GameOptionItems.push_back("Exit Game");
	OptionEmulationVideoItems.push_back("Hardware Filter:"); OptionEmulationVideoValueItems.push_back("Point");
	OptionEmulationVideoItems.push_back("Software Filter:"); OptionEmulationVideoValueItems.push_back("No Filter");
	OptionEmulationVideoItems.push_back("Flicker Filter:"); OptionEmulationVideoValueItems.push_back("0");
	OptionEmulationVideoItems.push_back("Soften:"); OptionEmulationVideoValueItems.push_back("Off");
	OptionEmulationVideoItems.push_back("Adjust Screen"); OptionEmulationVideoValueItems.push_back("");
	OptionEmulationVideoItems.push_back("Vsync:"); OptionEmulationVideoValueItems.push_back("On");
	OptionEmulationVideoItems.push_back("Dim Resize Screen:"); OptionEmulationVideoValueItems.push_back("On");
	OptionEmulationVideoItems.push_back("10x11 Pixel Ratio:"); OptionEmulationVideoValueItems.push_back("Off");
	OptionEmulationVideoItems.push_back("Screen Rotation:"); OptionEmulationVideoValueItems.push_back("Disabled");
	OptionEmulationVideoItems.push_back("Screenshot Save Slot:"); OptionEmulationVideoValueItems.push_back("1");
	OptionEmulationVideoItems.push_back("FPS Enabled:"); OptionEmulationVideoValueItems.push_back("False");
	OptionEmulationVideoItems.push_back("Frame Skip When Needed:"); OptionEmulationVideoValueItems.push_back("True");
	OptionEmulationVideoItems.push_back("Widescreen Fix:"); OptionEmulationVideoValueItems.push_back("Off");

	OptionEmulationSoundItems.push_back("Low Pass Filter:"); OptionEmulationSoundValueItems.push_back("Off");
	OptionEmulationSoundItems.push_back("Disable GUI Sound Effects:"); OptionEmulationSoundValueItems.push_back("False");
	OptionEmulationSoundItems.push_back("Sample Interpolation:"); OptionEmulationSoundValueItems.push_back("Linear");
	OptionEmulationSoundItems.push_back("FM Interpolation:"); OptionEmulationSoundValueItems.push_back("Disabled");
	
	GeneralOptionsSettings.push_back("High Score Saving:"); GeneralOptionsValueSettings.push_back("True");
	GeneralOptionsSettings.push_back("DIP Switches:"); GeneralOptionsValueSettings.push_back("Enabled");
	GeneralOptionsSettings.push_back("68K CPU Speed:"); GeneralOptionsValueSettings.push_back("100");

	std::ostringstream temp;
	temp << (float)(((float)CPUSpeed / 256) * 100) << "%";
	std::string temp2 = temp.str();
	GeneralOptionsValueSettings[2] = (char*)temp2.c_str();
	GeneralOptionsSettings.push_back("Neo Geo BIOS:"); GeneralOptionsValueSettings.push_back("");
							if(SNKBIOS == 0x00) GeneralOptionsValueSettings[3] = "MVS Asia/Europe ver. 6 (1 slot)";
							if(SNKBIOS == 0x01) GeneralOptionsValueSettings[3] = "MVS Asia/Europe ver. 5 (1 slot)";
							if(SNKBIOS == 0x02) GeneralOptionsValueSettings[3] = "MVS Asia/Europe ver. 3 (4 slot)";
							if(SNKBIOS == 0x03) GeneralOptionsValueSettings[3] = "MVS USA ver. 5 (2 slot)";
							if(SNKBIOS == 0x04) GeneralOptionsValueSettings[3] = "MVS USA ver. 5 (6 slot)";
							if(SNKBIOS == 0x05) GeneralOptionsValueSettings[3] = "MVS Japan ver. 6 (? slot)";
							if(SNKBIOS == 0x06) GeneralOptionsValueSettings[3] = "MVS Japan ver. 5 (? slot)";
							if(SNKBIOS == 0x07) GeneralOptionsValueSettings[3] = "MVS Japan ver. 3 (4 slot)";
							if(SNKBIOS == 0x08) GeneralOptionsValueSettings[3] = "NEO-MVH MV1C";
							if(SNKBIOS == 0x09) GeneralOptionsValueSettings[3] = "MVS Japan (J3)";								
							if(SNKBIOS == 0x0a) GeneralOptionsValueSettings[3] = "AES Japan";
							if(SNKBIOS == 0x0b) GeneralOptionsValueSettings[3] = "AES Asia";
							if(SNKBIOS == 0x0c) GeneralOptionsValueSettings[3] = "Development Kit";
							if(SNKBIOS == 0x0d) GeneralOptionsValueSettings[3] = "Deck ver. 6 (Git Ver 1.3)";
							if(SNKBIOS == 0x0e) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 2.3";
							if(SNKBIOS == 0x0f) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 2.3 (alt)";
							if(SNKBIOS == 0x10) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 2.2";
							if(SNKBIOS == 0x11) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 2.1";
							if(SNKBIOS == 0x12) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 2.0";
							if(SNKBIOS == 0x13) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 1.3";
							if(SNKBIOS == 0x14) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 1.2";
							if(SNKBIOS == 0x15) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 1.2 (alt)";
							if(SNKBIOS == 0x16) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 1.1";
							if(SNKBIOS == 0x17) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 1.0";

	GeneralOptionsSettings.push_back("Neo Geo Free PLay:"); GeneralOptionsValueSettings.push_back("Disabled");
	
	GeneralOptionsSettings.push_back("Analog Dead Zone:"); GeneralOptionsValueSettings.push_back("100");
	std::ostringstream temp3;
	temp3 << XBINPUT_DEADZONE;
	std::string temp23 = temp3.str();
	GeneralOptionsValueSettings[5] = (char*)temp23.c_str();

	SaveStateItems.push_back("Slot 1");
	SaveStateItems.push_back("Slot 2");
	SaveStateItems.push_back("Slot 3");
	SaveStateItems.push_back("Slot 4");
	SaveStateItems.push_back("Slot 5");
	SaveStateItems.push_back("Slot 6");
	SaveStateItems.push_back("Slot 7");
	SaveStateItems.push_back("Slot 8");
	SaveStateItems.push_back("Slot 9");
	SaveStateItems.push_back("Slot 10");
	LoadStateItems.push_back("Slot 1");
	LoadStateItems.push_back("Slot 2");
	LoadStateItems.push_back("Slot 3");
	LoadStateItems.push_back("Slot 4");
	LoadStateItems.push_back("Slot 5");
	LoadStateItems.push_back("Slot 6");
	LoadStateItems.push_back("Slot 7");
	LoadStateItems.push_back("Slot 8");
	LoadStateItems.push_back("Slot 9");
	LoadStateItems.push_back("Slot 10");

	OptionScreen();
	Device->CreateVertexBuffer(sizeof(VertexList),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBuffer);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferExitGame);	
	SetRenderStates();
	SetHardwareFilter();
	OptionControllerTurboItems.push_back("Controller:"); 
	OptionControllerTurboValueItems.push_back("1"); ;
	OptionControllerTurboItems.push_back("Button A Turbo:"); 
	OptionControllerTurboValueItems.push_back("Off");
	OptionControllerTurboItems.push_back("Button B Turbo:"); 
	OptionControllerTurboValueItems.push_back("Off");
	OptionControllerTurboItems.push_back("Button X Turbo:"); 
	OptionControllerTurboValueItems.push_back("Off");
	OptionControllerTurboItems.push_back("Button Y Turbo:"); 
	OptionControllerTurboValueItems.push_back("Off");
	OptionControllerTurboItems.push_back("Button Left TriggerTurbo:"); 
	OptionControllerTurboValueItems.push_back("Off");
	OptionControllerTurboItems.push_back("Button Right Trigger Turbo:"); 
	OptionControllerTurboValueItems.push_back("Off");
	OptionControllerTurboItems.push_back("Button Black Turbo:"); 
	OptionControllerTurboValueItems.push_back("Off");
	OptionControllerTurboItems.push_back("Button White Turbo:"); 
	OptionControllerTurboValueItems.push_back("Off");
	OptionControllerTurboItems.push_back("Turbo Speed:"); 
	OptionControllerTurboValueItems.push_back("7");
	QueryPerformanceFrequency(&ticksPerSecondDelay);
	QueryPerformanceCounter(&tickDelay);
	lastTimeDelay = (FLOAT)tickDelay.QuadPart;
	ControllerInit();
	ResetScreenSaver();
	setDisplay = true;
	ArcadeSetting e;
	e.name = "Dip Switches";
	e.code = -1;
	e.count = 0;
	arcadeSettings.push_back(e);
	StartGame();
	BuildSkins();
	sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\previewborder.png");
	D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
		D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
		D3DX_DEFAULT,0,NULL,NULL,&TexPreviewBorder);

//	sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\logo.png");
//	D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
//		D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
//		D3DX_DEFAULT,0,NULL,NULL,&TexAnimatedLogo);

	sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\videoborder.png");
	D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
		D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
		D3DX_DEFAULT,0,NULL,NULL,&TexVideoBorder);

	sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\romborder.png");
	D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
		D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
		D3DX_DEFAULT,0,NULL,NULL,&TexROMBorder);

	sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\selectedborder.png");
	D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
		D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
		D3DX_DEFAULT,0,NULL,NULL,&TexSelectedBorder);

	sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\rombrowser.png");
	D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
		D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
		D3DX_DEFAULT,0,NULL,NULL,&TexROMBrowser);

	sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\logomainmenu.png");
	D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
		D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
		D3DX_DEFAULT,0,NULL,NULL,&TexAnimatedLogoMainMenu);

	sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\overlay.png");
	D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
		D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
		D3DX_DEFAULT,0,NULL,NULL,&TexMainMenuOverlay);

	sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\mainmenu.png");
	D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
		D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
		D3DX_DEFAULT,0,NULL,NULL,&TexMainMenu);

	QueryPerformanceFrequency(&ticksPerSecondPreviewSwitch);
	QueryPerformanceCounter(&tickPreviewSwitch);
	lastTimePreviewSwitch = (FLOAT)tickPreviewSwitch.QuadPart;
	Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferPreview);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferPreviewBorder);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferPreviewVertical);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferPreviewBorderVertical);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferInfoBorder);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferInfoBorderSimple);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferVideoBorder);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferDualVideoBorder);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferROMBorder);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferSelectBorder);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferAlternatePreview);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferAlternatePreviewBorder);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferAlternatePreviewVertical);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferAlternatePreviewBorderVertical);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferAnimatedLogo);
	Device->CreateVertexBuffer(sizeof(VertexListMenu),D3DUSAGE_DYNAMIC,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferAnimatedLogoMainMenu);
	Device->CreateVertexBuffer(sizeof(VertexListImage),0,D3DFVF_CUSTOMVERTEX,D3DPOOL_DEFAULT,&VertexBufferImage);

	BuildFavorites();
	if(GameFavoriteSelected > FavoritesDatabase.size() - 1)
		GameFavoriteSelected = 0;
	FilterItems.push_back("Custom");
	FilterItems.push_back("Manufacturer");
	FilterItems.push_back("Year");
	FilterItems.push_back("Genre");
	MainMenuItems.push_back("Select Game");
	MainMenuItems.push_back("Favorite Games");
	MainMenuItems.push_back("Filter Games");
	MainMenuItems.push_back("Options");
	MainMenuItems.push_back("Help");
	MainMenuItems.push_back("Exit");
	OptionItems.push_back("Video Options");
	OptionItems.push_back("Sound Options");
	OptionItems.push_back("GUI Options");
	OptionItems.push_back("Rebuild Game List");
	OptionItems.push_back("GUI Skin");
	OptionItems.push_back("Image Viewer");
	OptionItems.push_back("Generate DAT Files");

	OptionVideoItems.push_back("Hardware Filter:"); OptionVideoValueItems.push_back("Point");
	OptionVideoItems.push_back("Software Filter:"); OptionVideoValueItems.push_back("No Filter");
	OptionVideoItems.push_back("Resolution:"); OptionVideoValueItems.push_back("1080i");
	OptionVideoItems.push_back("Flicker Filter:"); OptionVideoValueItems.push_back("0");
	OptionVideoItems.push_back("Soften:"); OptionVideoValueItems.push_back("Off");
	OptionVideoItems.push_back("Adjust Screen"); OptionVideoValueItems.push_back("");
	OptionVideoItems.push_back("Vsync:"); OptionVideoValueItems.push_back("On");
//	OptionVideoItems.push_back("Dim Resize Screen:"); OptionVideoValueItems.push_back("On");
	OptionVideoItems.push_back("10x11 Pixel Ratio:"); OptionVideoValueItems.push_back("Off");
	OptionVideoItems.push_back("Widescreen Fix:"); OptionVideoValueItems.push_back("Off");
	OptionVideoItems.push_back("Auto Rotate Vertical Games:"); OptionVideoValueItems.push_back("On");		

	if(HardwareFilter == 0)
		OptionVideoValueItems[0] = "None";
	if(HardwareFilter == 1)
		OptionVideoValueItems[0] = "Point";
	if(HardwareFilter == 2)
		OptionVideoValueItems[0] = "Bilinear";
	if(HardwareFilter == 3)
		OptionVideoValueItems[0] = "Trilinear";
	if(HardwareFilter == 4)
		OptionVideoValueItems[0] = "Anisotropic";
	if(HardwareFilter == 5)
		OptionVideoValueItems[0] = "Quincunx";
	if(HardwareFilter == 6)
		OptionVideoValueItems[0] = "Gaussian Cubic";
	if(SoftwareFilter == 0)
		OptionVideoValueItems[1] = "No Filter";
	if(SoftwareFilter == 1)
		OptionVideoValueItems[1] = "SuperScale2X";
	if(SoftwareFilter == 2)
		OptionVideoValueItems[1] = "AdvanceMame2X";
	if(SoftwareFilter == 3)
		OptionVideoValueItems[1] = "HQ2X";
	if(SoftwareFilter == 4)
		OptionVideoValueItems[1] = "Simple2X";
	if(SoftwareFilter == 5)
		OptionVideoValueItems[1] = "Scanline";
	if(SoftwareFilter == 6)
		OptionVideoValueItems[1] = "2xSaI";
	if(SoftwareFilter == 7)
		OptionVideoValueItems[1] = "Super2xSaI";
	if(SoftwareFilter == 8)
		OptionVideoValueItems[1] = "SuperEagle";
	if(SoftwareFilter == 9)
		OptionVideoValueItems[1] = "SuperScale75";
	if(HDMode == 0) 
		OptionVideoValueItems[2] = "480i/480p";
	if(HDMode == 1) 
		OptionVideoValueItems[2] = "720p";
	if(HDMode == 2) 
		OptionVideoValueItems[2] = "1080i";
	if(FlickerFilter == 0)
		OptionVideoValueItems[3] = "0";
	if(FlickerFilter == 1)
		OptionVideoValueItems[3] = "1";
	if(FlickerFilter == 2)
		OptionVideoValueItems[3] = "2";
	if(FlickerFilter == 3)
		OptionVideoValueItems[3] = "3";
	if(FlickerFilter == 4)
		OptionVideoValueItems[3] = "4";
	if(FlickerFilter == 5)
		OptionVideoValueItems[3] = "5";
	if(Soften == 0)
		OptionVideoValueItems[4] = "Off";
	if(Soften == 1)
		OptionVideoValueItems[4] = "On";
	if(vsyncEnabled == 0)
		OptionVideoValueItems[6] = "Off";
	if(vsyncEnabled == 1)
		OptionVideoValueItems[6] = "On";
//	if(dimColor == 1) 
//		OptionVideoValueItems[6] = "On";
//	if(dimColor == 0)
//		OptionVideoValueItems[6] = "Off";
	if(pixelRatio == 1) 
		OptionVideoValueItems[7] = "On";
	if(pixelRatio == 0)
		OptionVideoValueItems[7] = "Off";
	if(AspectCorrect == 0)
		OptionVideoValueItems[8] = "Off";
	if(AspectCorrect == 1)
		OptionVideoValueItems[8] = "On";
	if(FreeRotate == 0)
		OptionVideoValueItems[9] = "On";
	if(FreeRotate == 1)
		OptionVideoValueItems[9] = "Off";

	OptionSoundItems.push_back("Frequency:"); OptionSoundValueItems.push_back("22050");
	OptionSoundItems.push_back("Low Pass Filter:"); OptionSoundValueItems.push_back("Off");
	OptionSoundItems.push_back("Disable GUI Sound Effects:"); OptionSoundValueItems.push_back("False");
	OptionSoundItems.push_back("GUI Background Music Volume:"); OptionSoundValueItems.push_back("0");
	OptionSoundItems.push_back("Sample Interpolation:"); OptionSoundValueItems.push_back("Linear");
	OptionSoundItems.push_back("FM Interpolation:"); OptionSoundValueItems.push_back("Disabled");
	if(nAudSampleRate == 11025)
		OptionSoundValueItems[0] = "11025";
	if(nAudSampleRate == 22050)
		OptionSoundValueItems[0] = "22050";
	if(nAudSampleRate == 44100)
		OptionSoundValueItems[0] = "44100";
	if(nAudSampleRate == 48000)
		OptionSoundValueItems[0] = "48000";
	if(nAudDSPModule == 0)
		OptionSoundValueItems[1] = "Off";
	else
		OptionSoundValueItems[1] = "On";
	if(disableMenuSounds == 0)
		OptionSoundValueItems[2] = "False";
	else
		OptionSoundValueItems[2] = "True";
	std::ostringstream tempn;
	tempn << BackgroundMusicVolume;
	std::string temp2n = temp.str();
	OptionSoundValueItems[3] = (char*)temp2n.c_str();
	if(nInterpolation == 1)
		OptionSoundValueItems[4] = "Linear";
	else
		OptionSoundValueItems[4] = "Cubic";
	if(nFMInterpolation == 0)
		OptionSoundValueItems[5] = "Disabled";
	else
		OptionSoundValueItems[5] = "Enabled";
	
	OptionGUIItems.push_back("Image Options");
	OptionGUIItems.push_back("Text Options");

	OptionGUITextItems.push_back("Game List Width:"); OptionGUITextValueItems.push_back(ConvertIntToString(GameListWidth));
	OptionGUITextItems.push_back("Game List Scroll Speed:"); OptionGUITextValueItems.push_back(ConvertIntToString(scrollSpeed));
	OptionGUITextItems.push_back("Game List Count:");  OptionGUITextValueItems.push_back(ConvertIntToString(GameListCount));
	OptionGUITextItems.push_back("Text Vertical Space:"); OptionGUITextValueItems.push_back(ConvertIntToString(vSpace));
	OptionGUITextItems.push_back("Font Size:"); OptionGUITextValueItems.push_back(ConvertFloatToString(FontSize));
	OptionGUITextItems.push_back("Menu Spacing:"); OptionGUITextValueItems.push_back(ConvertIntToString(MenuSpacing));
	OptionGUITextItems.push_back("Game List Adjust"); OptionGUITextValueItems.push_back("");
	OptionGUITextItems.push_back("Main Menu Adjust"); OptionGUITextValueItems.push_back("");
	OptionGUITextItems.push_back("Menu Details Adjust"); OptionGUITextValueItems.push_back("");
	OptionGUITextItems.push_back("Emulation Option Menu Adjust"); OptionGUITextValueItems.push_back("");
	OptionGUITextItems.push_back("Option Menu Adjust"); OptionGUITextValueItems.push_back("");
	OptionGUITextItems.push_back("Selected Game Text Adjust"); OptionGUITextValueItems.push_back("");
	OptionGUITextItems.push_back("Next Page"); OptionGUITextValueItems.push_back("");
	
	OptionGUITextPage2Items.push_back("Game Guide Line Count:"); OptionGUITextPage2ValueItems.push_back(ConvertIntToString(GameGuideLines));
	OptionGUITextPage2Items.push_back("Game Guide Color:"); 
	if(GameGuideColor == 0) 
		OptionGUITextPage2ValueItems.push_back("Green");
	else
		OptionGUITextPage2ValueItems.push_back("White");
	OptionGUITextPage2Items.push_back("Game Guide Font Size:"); OptionGUITextPage2ValueItems.push_back(ConvertFloatToString(GameGuideFontSize));
	OptionGUITextPage2Items.push_back("Game Guide Width:"); OptionGUITextPage2ValueItems.push_back(ConvertIntToString(GameGuideWidth));
	OptionGUITextPage2Items.push_back("Game Guide Vertical Space:"); OptionGUITextPage2ValueItems.push_back(ConvertIntToString(GameGuideVSpace));
	OptionGUITextPage2Items.push_back("Main Menu Font Size:"); OptionGUITextPage2ValueItems.push_back(ConvertFloatToString(MainMenuFontSize));
	OptionGUITextPage2Items.push_back("Main Menu Vertical Space:"); OptionGUITextPage2ValueItems.push_back(ConvertIntToString(MainMenuVSpace));
	OptionGUITextPage2Items.push_back("Main Menu Centered:"); 
	if(MainMenuCentered == 0)
		OptionGUITextPage2ValueItems.push_back("False");
	else
		OptionGUITextPage2ValueItems.push_back("True");

	OptionGUITextPage2Items.push_back("Game Display:");
	if(DisplayMode == 2)
		OptionGUITextPage2ValueItems.push_back("All Games");
	if(DisplayMode == 0)
		OptionGUITextPage2ValueItems.push_back("Parent Sets");
	if(DisplayMode == 1)
		OptionGUITextPage2ValueItems.push_back("Clones");


	OptionGUITextPage2Items.push_back("Highlight Parents:");
	if(HighlightParent == 0)
		OptionGUITextPage2ValueItems.push_back("Disabled");
	if(HighlightParent == 1)
		OptionGUITextPage2ValueItems.push_back("Enabled");
		
	OptionGUITextPage2Items.push_back("Highlight Non-Working:");
	if(HighlightNotWorking == 0)
		OptionGUITextPage2ValueItems.push_back("Disabled");
	if(HighlightNotWorking == 1)
		OptionGUITextPage2ValueItems.push_back("Enabled");		

	OptionGUIImageItems.push_back("GUI Adjust"); OptionGUIImageValueItems.push_back("");
	OptionGUIImageItems.push_back("Dual Preview Adjust"); OptionGUIImageValueItems.push_back("");
	OptionGUIImageItems.push_back("Exit Game Image Adjust"); OptionGUIImageValueItems.push_back("");
	OptionGUIImageItems.push_back("Exit Game Zoom Speed:"); OptionGUIImageValueItems.push_back(ConvertIntToString(zoomSpeed));
	OptionGUIImageItems.push_back("Image Fade Speed:"); OptionGUIImageValueItems.push_back(ConvertIntToString(fadeSpeed));
	OptionGUIImageItems.push_back("Video Preview Adjust"); OptionGUIImageValueItems.push_back("");
	OptionGUIImageItems.push_back("Main Menu Video Preview Adjust"); OptionGUIImageValueItems.push_back("");
	OptionGUIImageItems.push_back("Dual Preview Border Adjust"); OptionGUIImageValueItems.push_back("");
	OptionGUIImageItems.push_back("Video Preview Border Adjust"); OptionGUIImageValueItems.push_back("");
	OptionGUIImageItems.push_back("ROM List Background Adjust"); OptionGUIImageValueItems.push_back("");
	OptionGUIImageItems.push_back("Selected Game Background Adjust"); OptionGUIImageValueItems.push_back("");
	OptionGUIImageItems.push_back("Preview Adjust"); OptionGUIImageValueItems.push_back("");
	OptionGUIImageItems.push_back("Preview Border Adjust"); OptionGUIImageValueItems.push_back("");
	OptionGUIImageItems.push_back("Marquee Adjust"); OptionGUIImageValueItems.push_back("");
	OptionGUIImageItems.push_back("Next Page"); OptionGUIImageValueItems.push_back("");

//	OptionGUIImageItemsPage2.push_back("ROM Browser Animated Logo Speed:"); 
	std::ostringstream q0;
//	q0 << speedROMBrowserLogo;
	std::string w0 = q0.str();
//	OptionGUIImageValueItemsPage2.push_back((char*)w0.c_str());

//	OptionGUIImageItemsPage2.push_back("ROM Browser Animated Logo Distance:"); 
	std::ostringstream q1;
//	q1 << distanceROMBrowserLogo;
	std::string w1 = q1.str();
//	OptionGUIImageValueItemsPage2.push_back((char*)w1.c_str());

	OptionGUIImageItemsPage2.push_back("Main Menu Animated Logo Adjust"); OptionGUIImageValueItemsPage2.push_back("");
	OptionGUIImageItemsPage2.push_back("Main Menu Animated Logo Speed:"); 
	std::ostringstream e0;
	e0 << speedLogoMainMenu;
	w0 = e0.str();
	OptionGUIImageValueItemsPage2.push_back((char*)w0.c_str());

	OptionGUIImageItemsPage2.push_back("Main Menu Animated Logo Distance:"); 
	std::ostringstream e1;
	e1 << distanceLogoMainMenu;
	w1 = e1.str();
	OptionGUIImageValueItemsPage2.push_back((char*)w1.c_str());
	//OptionGUIImageItemsPage2.push_back("Simple Info Panel Adjust"); OptionGUIImageValueItemsPage2.push_back("");
	OptionGUIImageItemsPage2.push_back("Vertical Preview Adjust"); OptionGUIImageValueItemsPage2.push_back("");
	OptionGUIImageItemsPage2.push_back("Vertical Preview Border Adjust"); OptionGUIImageValueItemsPage2.push_back("");
	OptionGUIImageItemsPage2.push_back("Dual Vertical Preview Adjust"); OptionGUIImageValueItemsPage2.push_back("");
    OptionGUIImageItemsPage2.push_back("Dual Vertical Preview Border Adjust"); OptionGUIImageValueItemsPage2.push_back("");
	//OptionGUIImageItemsPage2.push_back("Simple Info Panel Enabled:"); 
	/*if(GameInfoEnabled == 1)
		OptionGUIImageValueItemsPage2.push_back("True");
	else
		OptionGUIImageValueItemsPage2.push_back("False");*/
	//OptionGUIImageItemsPage2.push_back("Detail Info Panel Enabled:"); 
	/*if(GameInfoDetailEnabled == 1)
		OptionGUIImageValueItemsPage2.push_back("True");
	else
		OptionGUIImageValueItemsPage2.push_back("False");*/
	OptionGUIImageItemsPage2.push_back("Exit Game Image Adjust - 90"); OptionGUIImageValueItemsPage2.push_back("");
	OptionGUIImageItemsPage2.push_back("Exit Game Image Adjust - 180"); OptionGUIImageValueItemsPage2.push_back("");
	OptionGUIImageItemsPage2.push_back("Exit Game Image Adjust - 270"); OptionGUIImageValueItemsPage2.push_back("");
	OptionGUIImageItemsPage2.push_back("Next Page"); OptionGUIImageValueItemsPage2.push_back("");
	OptionGUIImageItemsPage3.push_back("Main Menu Icon 1 Adjust"); OptionGUIImageValueItemsPage3.push_back("");
	OptionGUIImageItemsPage3.push_back("Main Menu Icon 2 Adjust"); OptionGUIImageValueItemsPage3.push_back("");
	OptionGUIImageItemsPage3.push_back("Main Menu Icon 3 Adjust"); OptionGUIImageValueItemsPage3.push_back("");
	OptionGUIImageItemsPage3.push_back("Main Menu Icon 4 Adjust"); OptionGUIImageValueItemsPage3.push_back("");
	OptionGUIImageItemsPage3.push_back("Main Menu Icon 5 Adjust"); OptionGUIImageValueItemsPage3.push_back("");
	OptionGUIImageItemsPage3.push_back("Main Menu Icon 6 Adjust"); OptionGUIImageValueItemsPage3.push_back("");
	OptionGUIImageItemsPage3.push_back("Dual Video Preview Adjust"); OptionGUIImageValueItemsPage3.push_back("");
	OptionGUIImageItemsPage3.push_back("Dual Video Preview Border Adjust"); OptionGUIImageValueItemsPage3.push_back("");
	OptionGUIImageItemsPage3.push_back("Video Previews:"); OptionGUIImageValueItemsPage3.push_back("Enabled");
	OptionGUIImageItemsPage3.push_back("Exit Game Controls:"); OptionGUIImageValueItemsPage3.push_back("Left Trigger + Right Trigger");
	OptionGUIImageItemsPage3.push_back("Main Menu Video Preview Change:"); OptionGUIImageValueItemsPage3.push_back("Enabled");
	OptionGUIImageItemsPage3.push_back("Video Preview Sound:"); OptionGUIImageValueItemsPage3.push_back("Enabled");

	if(PauseGame == 0)
		OptionGUIImageValueItemsPage3[9] = "Right Analog Click";
	if(PauseGame == 1)
		OptionGUIImageValueItemsPage3[9] = "Left Trigger + Right Trigger";
	if(PauseGame == 2)
		OptionGUIImageValueItemsPage3[9] = "Back + Start";
	if(PauseGame == 3)
		OptionGUIImageValueItemsPage3[9] = "Left Trigger + Back";
	if(PauseGame == 4)
		OptionGUIImageValueItemsPage3[9] = "Right Trigger + Back";
    if(PauseGame == 5)
	    OptionGUIImageValueItemsPage3[9] = "A + Y";
		
	if(MovieEnabled) {
		OptionGUIImageValueItemsPage3[8] = "Enabled";
	}
	else {
		OptionGUIImageValueItemsPage3[8] = "Disabled";
	}

	if(MainMenuMovieSwitchEnabled) {
		OptionGUIImageValueItemsPage3[10] = "Enabled";
	}
	else {
		OptionGUIImageValueItemsPage3[10] = "Disabled";
	}
	if(MovieSound) {
		OptionGUIImageValueItemsPage3[11] = "Enabled";
	}
	else {
		OptionGUIImageValueItemsPage3[11] = "Disabled";
	}
	ResetAnimatedLogo();
	ResetAnimatedLogoMainMenu();
	if(GUIState == 0)
		MenuBackground();
	setDisplay = true;

	QueryPerformanceFrequency(&ticksPerSecondROMBrowserLogo);
	QueryPerformanceFrequency(&ticksPerSecondLogoMainMenu);

	if(!LoadGameList()) {
		Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
		FontSetColour(0xffffff);
		FontCenteredText(ConvertCharStringToWCHAR("Building Game List..."), 320, 240, 640);
		Present();
		Device->SetFlickerFilter(FlickerFilter);
		Device->SetSoftDisplayFilter(Soften);
		Scan();
	}

	QueryPerformanceFrequency((union _LARGE_INTEGER *) m_performanceFreq);
	m_mp3player.dsound_init() ;
	m_mp3player.m_fps = 60;
	sprintf(fileName,"%s%s%s", "D:\\skins\\", SkinPath.c_str(), "\\backgroundmusic.mp3");
	m_mp3player.loadFile(fileName, 1, 0, 70*60*75 );
	//m_mp3player.insertSilence( 22050 );
	m_mp3player.pause( FALSE );
	m_mp3player.adjust_volume(BackgroundMusicVolume);
	memset( m_mp3player.m_pSoundBufferData, 0, m_mp3player.stream_buffer_size);

	if(GUIState != MAIN_MENU) {
		g_hSoundThread = CreateThread( 
			NULL,                        // (this parameter is ignored)
			0,                           // use default stack size  
			Mp3player_ThreadFunc,                  // thread function 
			NULL,                // argument to thread function 
			0,                           // use default creation flags 
			&g_dwSoundThreadId); 
		//dprintf("Music Started\n");
	}
	
	if(GUIState == ROM_SELECT) {
		//dprintf("GUIState == ROM_SELECT\n");
		resumeGUI = true;
		if(CustomSet == 1) {
			if(CustomSelected == 0) {
				GameDatabase.clear();
				for(int i = 0; i < GameDatabaseTemp.size(); i++) {
					if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "CPS1") == 0)) {
						CheckFilter(i);
					}
				}
				if(GameSelected > GameDatabase.size() - 1)
					GameSelected = 0;
				UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
				//fadeColor = 255;
			}
			if(CustomSelected == 1) {
				GameDatabase.clear();
				for(int i = 0; i < GameDatabaseTemp.size(); i++) {
					if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "CPS2") == 0)) {
						CheckFilter(i);
					}
				}
				if(GameSelected > GameDatabase.size() - 1)
					GameSelected = 0;
				UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
				//fadeColor = 255;
			}
			if(CustomSelected == 2) {
				//dprintf("CustomSelected == 2\n");
				GameDatabase.clear();
				for(int i = 0; i < GameDatabaseTemp.size(); i++) {
					if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Neo Geo MVS") == 0) ||
					   (_tcscmp(GameDatabaseTemp[i].system.c_str(), "Neo Geo AES") == 0)) {
						CheckFilter(i);
					}
				}
				if(GameSelected > GameDatabase.size() - 1)
					GameSelected = 0;
				UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
				//fadeColor = 255;
			}
			if(CustomSelected == 3) {
				GameDatabase.clear();
				for(int i = 0; i < GameDatabaseTemp.size(); i++) {
					if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "CPS1") == 0) || 
						(_tcscmp(GameDatabaseTemp[i].system.c_str(), "CPS2") == 0)) {
							CheckFilter(i);
					}
				}
				if(GameSelected > GameDatabase.size() - 1)
					GameSelected = 0;
				UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
				//fadeColor = 255;
			}
			if(CustomSelected == 4) {
				GameDatabase.clear();
				for(int i = 0; i < GameDatabaseTemp.size(); i++) {
					if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "CPS1") == 0) || 
						(_tcscmp(GameDatabaseTemp[i].system.c_str(), "CPS2") == 0) ||
                        (_tcscmp(GameDatabaseTemp[i].system.c_str(), "Neo Geo MVS") == 0) ||
						(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Neo Geo AES") == 0)) {
						CheckFilter(i);
					}
				}
				if(GameSelected > GameDatabase.size() - 1)
					GameSelected = 0;
				UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
				//fadeColor = 255;
			}
			if(CustomSelected == 5) {
				GameDatabase.clear();
				for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				    if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "PolyGameMaster") == 0) ||
					   (_tcscmp(GameDatabaseTemp[i].system.c_str(), "PolyGameMaster based") == 0)) {
						CheckFilter(i);
					}
				}
				if(GameSelected > GameDatabase.size() - 1)
					GameSelected = 0;
				UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
				//fadeColor = 255;
			}
			if(CustomSelected == 6) {
				GameDatabase.clear();
				for(int i = 0; i < GameDatabaseTemp.size(); i++) {
					if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Cave") == 0)) {
						CheckFilter(i);
					}
				}
				if(GameSelected > GameDatabase.size() - 1)
					GameSelected = 0;
				UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
				//fadeColor = 255;
			}
			if(CustomSelected == 7) {
				GameDatabase.clear();
				for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				    if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Cave") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PolyGameMaster") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PolyGameMaster based") == 0)) {
						CheckFilter(i);
					}
				}
				if(GameSelected > GameDatabase.size() - 1)
					GameSelected = 0;
				UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
				//fadeColor = 255;
			}
			if(CustomSelected == 8) {
				GameDatabase.clear();
				for(int i = 0; i < GameDatabaseTemp.size(); i++) {
					if(((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Psikyo 68EC020") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS3-V1") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS5") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS4") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS5V2") == 0))) {
						CheckFilter(i);
					}
				}
				if(GameSelected > GameDatabase.size() - 1)
					GameSelected = 0;
				UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
				//fadeColor = 255;
			}
			if(CustomSelected == 9) {
				GameDatabase.clear();
				for(int i = 0; i < GameDatabaseTemp.size(); i++) {
					if(((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Psikyo 68EC020") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS3-V1") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS5") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS4") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Cave") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS5V2") == 0))) {
						CheckFilter(i);
					}
				}
				if(GameSelected > GameDatabase.size() - 1)
					GameSelected = 0;
				UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
				//fadeColor = 255;
			}
			if(CustomSelected == 10) {
				GameDatabase.clear();
				for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				 if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "CPS1") != 0) && 
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "CPS2") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Cave") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Megadrive") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Neo Geo MVS") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Neo Geo AES") != 0) &&					
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Psikyo 68EC020") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS3-V1") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS5") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Konami") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Kn") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Sega") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PolyGameMaster") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PS5V2") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "PolyGameMaster based") != 0)&&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Taito Misc") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Taito-F2") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Taito-X") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Taito-Z") != 0)&&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "To") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Toaplan BCU-2 / FCU-2 based") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Toaplan GP9001 based") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Data East") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "De") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Dual Toaplan GP9001 based") != 0)) {
						CheckFilter(i);
					}
				}
				if(GameSelected > GameDatabase.size() - 1)
					GameSelected = 0;
				UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
				//fadeColor = 255;
			}
			if(CustomSelected == 11) {
				GameDatabase.clear();
				for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Konami") == 0) &&
				    (_tcscmp(GameDatabaseTemp[i].system.c_str(), "Kn") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Megadrive") != 0)) {
						CheckFilter(i);
					}
				}
				if(GameSelected > GameDatabase.size() - 1)
					GameSelected = 0;
				UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
				//fadeColor = 255;
			}
			
			if(CustomSelected == 12) {
				GameDatabase.clear();
				for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Sega") == 0) &&
				    (_tcscmp(GameDatabaseTemp[i].system.c_str(), "De") != 0) &&
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Data East") != 0)) {
						CheckFilter(i);
					}
				}
				if(GameSelected > GameDatabase.size() - 1)
					GameSelected = 0;
				UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
				//fadeColor = 255;
			}
			if(CustomSelected == 13) {
				GameDatabase.clear();
				for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Taito Misc") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Taito-F2") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Taito-X") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "To") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Taito-Z") == 0)) {
						CheckFilter(i);
					}
				}
				if(GameSelected > GameDatabase.size() - 1)
					GameSelected = 0;
				UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
				//fadeColor = 255;
			}
			if(CustomSelected == 14) {
				GameDatabase.clear();
				for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Toaplan BCU-2 / FCU-2 based") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Toaplan GP9001 based") == 0) ||
					(_tcscmp(GameDatabaseTemp[i].system.c_str(), "Dual Toaplan GP9001 based") == 0)) {
						CheckFilter(i);
					}
				}
				if(GameSelected > GameDatabase.size() - 1)
					GameSelected = 0;
				UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
				//fadeColor = 255;
			}
			
			if(CustomSelected == 15) {
				GameDatabase.clear();
				for(int i = 0; i < GameDatabaseTemp.size(); i++) {
                    if((_tcscmp(GameDatabaseTemp[i].system.c_str(), "Data East") == 0) ||
					   (_tcscmp(GameDatabaseTemp[i].system.c_str(), "De") == 0)) {
						CheckFilter(i);
					}
				}
				if(GameSelected > GameDatabase.size() - 1)
					GameSelected = 0;
				UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
				//fadeColor = 255;
			}
		}
		else if (CompanySet == 1) {
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].manufacturer.c_str(),  FilterCompany[CompanySelected].c_str()) == 0)) {
					CheckFilter(i);
				}
			}
			if(GameSelected > GameDatabase.size() - 1)
				GameSelected = 0;
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			//fadeColor = 255;
		}
		else if (YearSet == 1) {
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].date.c_str(),  FilterYear[YearSelected].c_str()) == 0)) {
					CheckFilter(i);
				}
			}
			if(GameSelected > GameDatabase.size() - 1)
				GameSelected = 0;
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			//fadeColor = 255;
		}
		else if (GenreSet == 1) {
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				if((_tcscmp(GameDatabaseTemp[i].genre.c_str(),  FilterGenre[GenreSelected].c_str()) == 0)) {
					CheckFilter(i);
				}
			}
			if(GameSelected > GameDatabase.size() - 1)
				GameSelected = 0;
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			//fadeColor = 255;
		}
		else {
			if(GameSelected > GameDatabase.size() - 1)
				GameSelected = 0;
			GameDatabase.clear();
			for(int i = 0; i < GameDatabaseTemp.size(); i++) {
				CheckFilter(i);
			}
			UpdatePreview(GameDatabase[GameSelected].name, GameDatabase[GameSelected].parent);
			//fadeColor = 255;
		}
	}
	else if (GUIState == FAVORITE_SELECT) {
		UpdatePreview(FavoritesDatabase[GameFavoriteSelected].name, FavoritesDatabase[GameFavoriteSelected].parent);
		//fadeColor = 255;
		resumeGUI = true;
	}
	else {
		GameSelected = 0;
		GameFavoriteSelected = 0;
		setDisplay = false;
		Device->Clear(0,NULL,D3DCLEAR_TARGET,0x0,1.0f,0);
		Device->Present( NULL, NULL, NULL, NULL );
		Device->SetFlickerFilter(FlickerFilter);
		Device->SetSoftDisplayFilter(Soften);
		GUIState = MAIN_MENU;
		SplashScreen();
		g_hSoundThread = CreateThread( 
			NULL,                        // (this parameter is ignored)
			0,                           // use default stack size  
			Mp3player_ThreadFunc,                  // thread function 
			NULL,                // argument to thread function 
			0,                           // use default creation flags 
			&g_dwSoundThreadId); 
		//dprintf("Music Started\n");
	}

	//dprintf("GUISTATE: %d\n", GUIState);
}

void UpdateGUI() {
	updateEffect();
	if(GUIState == MAIN_MENU) {
		MainMenu();
		return;
	}
	if(GUIState == ROM_SELECT) {
		ROMSelectMenu();
		return;
	}
	if(GUIState == FAVORITE_SELECT) {
		FavoriteSelectMenu();
		return;
	}
	if(GUIState == 3) {
		OptionMenu();
		return;
	}
	if(GUIState == 4) {
		OptionVideoMenu();
		return;
	}
	if(GUIState == 5) {
		OptionSoundMenu();
		return;
	}

	if(GUIState == 7) {
		OptionGUIMenu();
		return;
	}

	if(GUIState == 8) {
		OptionVideoScaleMenu();
		return;
	}

	if(GUIState == 9) {
		OptionGUITextItemsMenu();
		return;
	}

	if(GUIState == 10) {
		OptionGUIImageItemsMenu();
		return;
	}

	if(GUIState == 11) {
		GuideListMenu();
		return;
	}

	if(GUIState == 12) {
		FilterMenu();
		return;
	}

	if(GUIState == 13) {
		CustomMenu();
		return;
	}

	if(GUIState == 14) {
		CompanyMenu();
		return;
	}

	if(GUIState == 15) {
		YearMenu();
		return;
	}

	if(GUIState == 16) {
		GenreMenu();
		return;
	}

	if(GUIState == 17) {
		OptionGUITextItemsMenuPage2();
		return;
	}

	if(GUIState == 18) {
		OptionGUIImageItemsMenuPage2();
		return;
	}

	if(GUIState == 19) {
		GameListAdjust();
		return;
	}

	if(GUIState == 20) {
		MainMenuAdjust();
		return;
	}

	if(GUIState == 21) {
		MenuDetailAdjust();
		return;
	}

	if(GUIState == 22) {
		GameOptionAdjust();
		return;
	}

	if(GUIState == 23) {
		MenuAdjust();
		return;
	}

	if(GUIState == 24) {
		ROMAdjust();
		return;
	}

	if(GUIState == 27) { BackgroundAdjust(); return; }
	if(GUIState == 28) { PreviewAdjust(); return; }
	if(GUIState == 29) { ExitGameAdjust(); return; }
	if(GUIState == 30) { MovieAdjust(); return; }
	if(GUIState == 31) { MainMenuMovieAdjust(); return; }
	if(GUIState == 32) { PreviewBorderAdjust(); return; }
	if(GUIState == 34) { VideoBorderAdjust(); return; }
	if(GUIState == 35) { ROMBorderAdjust(); return; }
	if(GUIState == 36) { SelectBorderAdjust(); return; }
	if(GUIState == 37) { AlternatePreviewAdjust(); return; }
	if(GUIState == 38) { AlternatePreviewBorderAdjust(); return; }
	if(GUIState == 39) { AnimatedLogoAdjust(); return; }
	if(GUIState == 40) { AnimatedLogoMainMenuAdjust(); return; }
	if(GUIState == 42) { AlternatePreviewVerticalAdjust(); return; }
	if(GUIState == 43) { AlternatePreviewBorderVerticalAdjust(); return; }
	if(GUIState == 44) { PreviewVerticalAdjust(); return; }
	if(GUIState == 45) { PreviewBorderVerticalAdjust(); return; }
	if(GUIState == 46) { ExitGameAdjust90(); return; }
	if(GUIState == 47) { ExitGameAdjust180(); return; }
	if(GUIState == 48) { ExitGameAdjust270(); return; }
	if(GUIState == 49) {
		OptionGUIImageItemsMenuPage3();
		return;
	}
	if(GUIState == 50) { MainMenuOverlay1Adjust(); return; }
	if(GUIState == 51) { MainMenuOverlay2Adjust(); return; }
	if(GUIState == 52) { MainMenuOverlay3Adjust(); return; }
	if(GUIState == 53) { MainMenuOverlay4Adjust(); return; }
	if(GUIState == 54) { MainMenuOverlay5Adjust(); return; }
	if(GUIState == 55) { MainMenuOverlay6Adjust(); return; }
	if(GUIState == 56) { DualMovieAdjust(); return; }
	if(GUIState == 57) { DualVideoBorderAdjust(); return; }
	return;
}

void RunGUI() {
	while(true) {
		UpdateGUI();
		Sleep(1);
	}
}

LONG CALLBACK ExceptionFilter(_EXCEPTION_POINTERS* pExceptionInfo)
{
	DxSoundStop();
	FBACrashed();
	return 0;

}

void __cdecl main()
{
	srand(time(NULL));
	SetUnhandledExceptionFilter(ExceptionFilter);
	Init();
	RunGUI();
}